//////////////////////////////////////////////////////////////////////////////////////////////
//
// ADOBE CONFIDENTIAL
// ___________________
//
//  Copyright 2011 Adobe Systems Incorporated
//  All Rights Reserved.
//
// NOTICE:  All information contained herein is, and remains
// the property of Adobe Systems Incorporated and its suppliers,
// if any.  The intellectual and technical concepts contained
// herein are proprietary to Adobe Systems Incorporated and its
// suppliers and are protected by trade secret or copyright law.
// Dissemination of this information or reproduction of this material
// is strictly forbidden unless prior written permission is obtained
// from Adobe Systems Incorporated.
//////////////////////////////////////////////////////////////////////////////////////////////

window.getUrlVars = function (url) {
    'use strict';

    if (!url) {
        return;
    }
    
    var vars = {};
    url.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
        vars[key] = value;
    });
    return vars;
};

window.getThemeFromGETParam = function (url) {
    'use strict';
    var urlVars = window.getUrlVars(url), ret = '';
    if (urlVars) {
        ret = urlVars.theme;
    }

    return ret;
};

window.onDWThemeChange = function (theme) {
    "use strict";
    if (theme === 'dark') {
        document.body.setAttribute('class', 'dark');
    } else if (theme === 'midDark') {
        document.body.setAttribute('class', 'midDark');
    } else if (theme === 'midLight') {
        document.body.setAttribute('class', 'midLight');
    } else if (theme === 'light') {
        document.body.setAttribute('class', 'light');
    }
};


var initTheme = function () {
    "use strict";
    var theme = window.getThemeFromGETParam(window.location.href);
    window.onDWThemeChange(theme);
};