﻿
/*	
 Copyright 2014 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
  Utility functions for vmq.
*/

/*jslint vars: true, plusplus: true*/
/*global dw, DWVmqUtility, jQuery, vmqResourcePath, $, EVENT_CONSTANTS, window, document, VMQ_HEADLIGHT_CONSTANTS, VMQ_CONSTANTS */

function VMQUtility() {
    'use strict';
	
	/*
	 * argument to be passed for all headlight logging
	 */
	var headlightArgObj;
	
	var NoMQString = {
		"en_US": "Click the + icon on the ruler to add a media query",
		"cs_SZ": "Kliknutím na ikonu „+“ na pravítku přidáte multimediální dotaz",
		"de_DE": "Zum Hinzufügen einer Medienabfrage auf dem Lineal auf das „+“ klicken",
		"es_ES": "Haga clic en el icono “+” de la regla para añadir una consulta de medios",
		"fr_FR": "Cliquez sur l’icône « + » sur la règle pour ajouter une requête multimédia",
		"it_IT": "Fai clic sull’icona + sul righello per aggiungere una media query",
		"ja_JP": "メディアクエリーを追加するには、ルーラーの「+」アイコンをクリック",
		"ko_KR": "미디어 쿼리를 추가하려면 눈금자의 + 아이콘 클릭",
		"nl_NL": "Klik op het pluspictogram (+) op de liniaal om een mediaquery toe te voegen",
		"pl_PL": "Kliknij ikonę + na miarce, aby dodać zapytanie o media",
		"pt_BR": "Clique no ícone + na régua para adicionar uma consulta de mídia",
		"ru_RU": "Нажмите значок «+» на линейке, чтобы добавить медиазапрос.",
		"sv_SE": "Klicka på +-ikonen på linjalen för att lägga till en mediefråga",
		"tr_TR": "Ortam sorgusu eklemek için cetvelin üzerindeki + simgesini tıklatın",
		"zh_CN": "单击标尺上的“+”图标以添加媒体查询",
		"zh_TW": "按一下尺規上的 + 圖示以新增媒體查詢"
	};
	
	
	this.getLocalisedNoMQString = function (appLang) {
		if (!appLang) {
			appLang = "en_US";
		}
		if (appLang === "fr_MA") {
			// fr_MA falls back to french.
			// all other languages default to english
			appLang = "fr_FR";
		}
		if (NoMQString[appLang]) {
			return NoMQString[appLang];
		}
		return NoMQString.en_US;
	};
	
    /*
	 * UNSUED FUNCTION
     * This function returns localized string for a given string Id.
     */
    this.getLocalizedString = function (stringId) {
        var result = "";
        result = $.i18n.prop(stringId);
        return result;
    };
    
    /*
	 * UNSUED FUNCTION
	 */
    this.setUpLocalization = function () {
        /*
         * Set up strings for localization.
         */
        if (jQuery !== 'undefined') {

            var stringsPath = window.vmqResourcePath + '/Strings/';

            $.i18n.properties({
                name: 'VmqStrings',
                language: ' ',
                path: stringsPath,
                mode: 'map',
                callback: function () {
                }
            });
        }
    };
    
    /*
     * Detect if a given string is a number.
     */
    this.isNumber = function (n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    };

    /**
     * Remove '.' from id name as JQuery doen't support it, replace with '_'
     * @return {string} ID without '.' 
     */
    this.toValidID = function(id){
        return id.replace(/\./g, '_');
    };

    /**
     * Replace '_' with '.' in jquery id to get id with decimal numbers
     * @return {string} id without '_' 
     */
   this.toOriginalID = function(id){
        return id.replace(/_/g, '.')
    };

    /*
     * Makes the passed minwidth array unique by removing duplicates.
     */
	this.uniqueArray = function (uniqarr) {
        var i;

        i = 0;
        if (uniqarr.length > 0) {
            uniqarr[i].mediaStr = uniqarr[i].minpxstr;
        }
        
        i++;
        while (i < uniqarr.length) {
            if (uniqarr[i - 1].minpxvalue === uniqarr[i].minpxvalue) {
                uniqarr[i - 1].mediaStr += "+" + uniqarr[i].minpxstr;
                uniqarr.splice(i, 1);
            } else {
                uniqarr[i].mediaStr = uniqarr[i].minpxstr;
                i++;
                
            }
        }
        return uniqarr;
    };
    
    /*
     * Makes the passed minmaxwidth array unique by removing duplicates.
     */
    this.uniqueMinMaxArray = function (uniqarr) {
        var i;

        i = 0;
        
        if (uniqarr.length > 0) {
            uniqarr[i].mediaStr = uniqarr[i].minpxstr + ";" + uniqarr[i].maxpxstr;
        }
        
        i++;
        
        while (i < uniqarr.length) {
            if ((uniqarr[i - 1].minpxvalue === uniqarr[i].minpxvalue) && (uniqarr[i - 1].maxpxvalue === uniqarr[i].maxpxvalue)) {
                uniqarr[i - 1].mediaStr += "+" + uniqarr[i].minpxstr + ";" + uniqarr[i].maxpxstr;
                uniqarr.splice(i, 1);
            } else {
                uniqarr[i].mediaStr = uniqarr[i].minpxstr + ";" + uniqarr[i].maxpxstr;
                i++;
            }
        }
        return uniqarr;
    };

    /*
     * Makes the passed maxwidth array unique by removing duplicates.
     */
    this.uniqueMaxArray = function (uniqarr) {
        var i;

        i = 0;
        if (uniqarr.length > 0) {
            uniqarr[i].mediaStr = uniqarr[i].maxpxstr;
        }
        i++;
        
        while (i < uniqarr.length) {
            if (uniqarr[i - 1].maxpxvalue === uniqarr[i].maxpxvalue) {
                uniqarr[i - 1].mediaStr += "+" + uniqarr[i].maxpxstr;
                uniqarr.splice(i, 1);
            } else {
                uniqarr[i].mediaStr = uniqarr[i].maxpxstr;
                i++;
            }
            
        }
        return uniqarr;
    };


    /*
     * Compare function for minwidth array.
     */
    this.compareFN = function (mq1, mq2) {
        var min1str = mq1.minpxvalue;
        var min1res = min1str.substring(0, min1str.length - 2);

        var min2str = mq2.minpxvalue;
        var min2res = min2str.substring(0, min2str.length - 2);

        return min1res - min2res;
    };
    
    /*
     * Compare function for minmaxwidth array.
     */
    this.compareFNMinMax = function (mq1, mq2) {
        var min1str = mq1.minpxvalue;
        var min1res = min1str.substring(0, min1str.length - 2);

        var min2str = mq2.minpxvalue;
        var min2res = min2str.substring(0, min2str.length - 2);

        if (min1res !== min2res) {
            return min1res - min2res;
        } else {
            
            var max1str = mq1.maxpxvalue;
            var max1res = max1str.substring(0, max1str.length - 2);

            var max2str = mq2.maxpxvalue;
            var max2res = max2str.substring(0, max2str.length - 2);

            return max2res - max1res;
        }
    };
    
    /*
     * Compare function for maxwidth array.
     */
    this.compareFNmax = function (mq1, mq2) {
        var max1str = mq1.maxpxvalue;
        var max1res = max1str.substring(0, max1str.length - 2);

        var max2str = mq2.maxpxvalue;
        var max2res = max2str.substring(0, max2str.length - 2);

        return max2res - max1res;
    };

    /*
     * Sort function for minwidth array.
     */
    this.sortMinWidthArray = function (minwidthList) {
        if (minwidthList.length > 0) {
            minwidthList.sort(this.compareFN);
            minwidthList = this.uniqueArray(minwidthList);
        }
    };

    /*
     * Sort function for maxwidth array.
     */
    this.sortMaxWidthArray = function (maxwidthList) {
        if (maxwidthList.length > 0) {
            maxwidthList.sort(this.compareFNmax);
            maxwidthList = this.uniqueMaxArray(maxwidthList);
        }
    };

    /*
     * Sort function for minmaxwidth array.
     */
    this.sortMinMaxWidthArray = function (minmaxwidthList) {
        if (minmaxwidthList.length > 0) {
            minmaxwidthList.sort(this.compareFNMinMax);
            minmaxwidthList = this.uniqueMinMaxArray(minmaxwidthList);
        }
    };
    
    /*
     * Get the width string from the div.
     */
    this.getMQWidthStr = function (elementUnderMousePoint) {
        
        var widthStr = "";
        
        if (elementUnderMousePoint) {
            var widthAttr = elementUnderMousePoint.getAttribute("data-mediaStr");
            if (widthAttr) {
                widthStr = widthAttr;
            }
        }
        return widthStr;
    };
    
    /*
     * Function to check if the unit is valid.
     */
    this.isValidVmqUnit = function (unitStr) {
        
        if (unitStr.match(/(%|vmin|vmax|vw|vh)$/)) {
            return false;
        } else {
            return true;
        }
    };
	
	/*
	 * Function to set the event string for the headlight data 
	 */
	this.setHeadlightData = function (event) {
		
		if (headlightArgObj === undefined) {
			headlightArgObj = {
				category : VMQ_HEADLIGHT_CONSTANTS.category,
				subCategory : VMQ_HEADLIGHT_CONSTANTS.subCategory,
				eventString : event
			};
		} else {
			headlightArgObj.eventString = event;
		}
	};
	
	/*
	 * Get the headlight data
	 */
	this.getHeadlightData = function () {
		return headlightArgObj;
	};
    
    /*
     * Check if the key press needs to be handled
     */
    this.isValidTextEditKeyCode = function (keyCode) {
        if ((keyCode > 47 && keyCode < 58) || //Numbers
                (keyCode === 13) ||               //Enter
                (keyCode > 95 && keyCode < 106) || // numpad keys
                (keyCode === 110) ||  //dot in numpad
                (keyCode === 8) ||    //backSpace
                (keyCode === 46) ||   //Delete
                (keyCode === 37) || (keyCode === 38) || (keyCode === 39) || (keyCode === 40) ||
                (keyCode === 36) || (keyCode === 35) || //home and end keys
                (keyCode === 190)) {/* dot or period key */
            return true;
        } else {
            return false;
        }
    };
    
    /* 
     * Check if the key code in keypress event needs to be handled.
     * The key codes during keydown and keypress are different and
     * hence this separate check. The argument is event here. 
     * We restrict the user to enter values <= 9999.999 only
     */
    this.isValidTextEditKeyCodeOnKeyPressEvent = function (event) {
       
        if (!event) {
            return false;
        }
       
        var keyCode = event.keyCode,
            whichKeyCode = event.which;
       
        if ((whichKeyCode === 13) ||               //Enter
                (whichKeyCode === 8) ||                //backSpace
                (keyCode === 36) || (keyCode === 35) || //home and end keys
                ((keyCode === 37) || (keyCode === 38) || (keyCode === 39) || (keyCode === 40))) { //up,down,left,right
            return true;
        } else if (whichKeyCode > 47 && whichKeyCode < 58) { //Numbers(same for numpad)
            var newVal = String.fromCharCode(whichKeyCode);
            var curVal = event.target.innerHTML;
            //get the caret position to place the typed in char to find out if it is
            //within the range
            var range = window.getSelection().getRangeAt(0);
            var preCaretRange = range.cloneRange();
            preCaretRange.selectNodeContents(event.target);
            preCaretRange.setEnd(range.endContainer, range.endOffset);
            var caretOffset = preCaretRange.toString().length;
            var updatedVal = [curVal.slice(0, caretOffset), newVal, curVal.slice(caretOffset)].join('');
            if (updatedVal <= VMQ_CONSTANTS.upperLimit && updatedVal.length <= VMQ_CONSTANTS.maxDigits) {
                if (updatedVal.indexOf(".", 0) !== -1) {
                    if (updatedVal.split(".")[1].length <= VMQ_CONSTANTS.maxDecimalDigits) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } else if (whichKeyCode === 46) { //Dot(same in numpad)
            var numVal = event.target.innerHTML;
            //allow only 1 "."
            if (numVal.indexOf(".", 0) === -1) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    };
    
    
    /*
     * Check if the key press needs to be handled
     */
    this.isNonNumericKeyCode = function (keyCode) {
        if ((keyCode === 13) ||               //Enter
                (keyCode === 8) ||    //backSpace
                (keyCode === 46) ||   //Delete
                (keyCode === 37) || (keyCode === 38) || (keyCode === 39) || (keyCode === 40)) {
            return true;
        } else {
            return false;
        }
    };
    
    this.getMouseEventCaretRange = function (evt) {
        var range, x = evt.clientX, y = evt.clientY;

        // Try the simple IE way first
        if (document.body.createTextRange) {
            range = document.body.createTextRange();
            range.moveToPoint(x, y);
        } else if (typeof document.createRange !== "undefined") {
            // Try Mozilla's rangeOffset and rangeParent properties, which are exactly what we want

            if (typeof evt.rangeParent !== "undefined") {
                range = document.createRange();
                range.setStart(evt.rangeParent, evt.rangeOffset);
                range.collapse(true);
            } else if (document.caretPositionFromPoint) { // Try the standards-based way next
                var pos = document.caretPositionFromPoint(x, y);
                range = document.createRange();
                range.setStart(pos.offsetNode, pos.offset);
                range.collapse(true);
            } else if (document.caretRangeFromPoint) { // Next, the WebKit way
                range = document.caretRangeFromPoint(x, y);
            }
        }

        return range;
    };

    this.selectRange = function (range) {
        if (range) {
            if (typeof range.select !== "undefined") {
                range.select();
            } else if (typeof window.getSelection !== "undefined") {
                var sel = window.getSelection();
                sel.removeAllRanges();
                sel.addRange(range);
            }
        }
    };
}

/**
 * @Utility object declaration.
 * Global utility object that will be available to every one from the point this file evaled.
 */
window.DWVmqUtility = new VMQUtility();