/*
 Copyright 2019 Adobe Systems Incorporated.  All rights reserved.
*/
/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global $, liveViewObject, dwObject, liveExtensionsConfigPath, dwExtensionController, TAGS, KEYCODES,jQuery, MOUSE,DW_EXTENSION_EVENT, Node, parent */

const kActivityTimeout = 500;

class AutoCommit {


    /*************** AutoCommit: Public methods ***************/

    constructor() {
        'use strict';
        this._initialize();
    }

    onActivity() {
        'use strict';
        if (!this.m_enabled) {
            return;
        }
        this.m_activityTime = Date.now();
        if (this.m_timerId === 0)
            this._setTimer();
    }

    enable(bEnable) {
        'use strict';
        
        var changed = (this.m_enabled !== bEnable);
        this.m_enabled = bEnable;
        
        // call onActivity if m_enabled is intended to be change to true
        if (bEnable && changed)
            this.onActivity();
    }

    isEnabled() {
        'use strict';
        return this.m_enabled;
    }

    /*************** AutoCommit: Private methods ***************/

    _initialize() {
        'use strict';

        this.m_activityTime = 0;
        this.m_timerId = 0;
        this.m_enabled = true;
        this._timerCallback = this._timerCallback.bind(this);
    }

    _timerCallback() {
        'use strict';
        this.m_timerId = 0;
        if (!this.m_enabled) {
            return;
        }
        if((Date.now() - this.m_activityTime) > kActivityTimeout)
            this._initiateAutoCommit();
        else
            this._setTimer();
    }

    _initiateAutoCommit() {
        'use strict';

        dwExtensionController.sendMessage({ type: DW_EXTENSION_EVENT.AUTO_COMMIT });
        this.m_activityTime = 0;
    }

    _setTimer() {
        'use strict';
        this.m_timerId = window.setTimeout(this._timerCallback, kActivityTimeout);
    }
}