//Copyright 2012-2013 Adobe Systems Incorporated.  All rights reserved.

var helpDoc = MM.HELP_jQueryButton;			//need new help ids

var BUTTON_ID;
var LABEL_INPUT;
var PRIMARY_LIST;
var SECONDARY_LIST;
var DISABLED_CHECK;
var TEXT_CHECK;


// ********************* API FUNCTIONS ***************************

//--------------------------------------------------------------------
// FUNCTION:
//   canInspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document changes to decide whether
//   or not this property inspector should be displayed.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   true if the currently selected node is a Button element,
//   false if it is not.
//--------------------------------------------------------------------

function canInspectSelection() 
{
	var bCanInspectSelection = false;
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	
	if ( !selectedNode || !selectedNode.getTranslatedAttribute )
		return false;
	
	var attr = selectedNode.getTranslatedAttribute('button');
  
	if ( attr && attr.length > 0 )
	{

		bCanInspectSelection = true;
	
		// If the widget manager is out of sync, run the translator
		var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
		
		if (!widgetMgr)
			return;
	
		if ( !widgetMgr.getWidget('button', selectedNode.id ) )
		{ 
			dom.runTranslator("jQuery Widget");

			if ( !widgetMgr.getWidget('button', selectedNode.id ) )
		{ 
			// Running the translator failed to create a design time object
			// for this widget. Either caInspectSelection() was called in the
			// middle of an edit operation, which prevents the translator from
			// running right now, or an error occurred during the translation.

			bCanInspectSelection = false;
		}
		}  
	}

	return bCanInspectSelection;
}

//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This is an internal utility function that searches through the
//   Property Inspector document to find all of the UI controls we
//   will programatically manipulate, and stores handles to them in
//   global variables which are used in some of the other functions
//   for this Property Inspector.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function initializeUI() 
{
	BUTTON_ID = document.getElementById("idInput");	
	LABEL_INPUT = document.getElementById("labelInput")
	PRIMARY_LIST = new ListControl("primarySelect");
	SECONDARY_LIST = new ListControl("secondarySelect");
	DISABLED_CHECK = document.getElementById("disabledCheck");
	TEXT_CHECK = document.getElementById("textCheck");
}

//--------------------------------------------------------------------
// FUNCTION:
//   inspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document has changed and it has
//   been decided that this Property Inspector should be displayed.
//   This function syncs up the Property Inspector UI with the
//   widget's design-time object so that it accurately reflects
//   what is in the widget HTML markup and its JS constructor.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function inspectSelection() 
{
	dw.logEvent(UT_JQUERY_BUTTON, UT_JQUERY_BUTTON_INSPECT);
	// Call initializeUI() here; it's how the global variables get
	// initialized. The onLoad event on the body tag is never triggered
	// in inspectors.
	initializeUI();

	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	
	if (!canInspectSelection())
		return;
		
	var inputId = selectedNode.id;
	// Update the ID field in the PI.
	BUTTON_ID.value = inputId;	
	
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
  
	if (!widgetMgr)
		return;
	
	var button = widgetMgr.getWidget('button', inputId);
	
	if (!button)
	{
		return;
	}
	
	if (button && button.recalculateOpts)
		button.recalculateOpts();
	
	var iconValueArray = button.getIconValueArray();
	PRIMARY_LIST.setAll(iconValueArray, iconValueArray);
	var index = button.getPrimaryIconIndex();
	if( index && iconValueArray.length && index < iconValueArray.length )
		PRIMARY_LIST.setIndex(index);
	else
		PRIMARY_LIST.setIndex(0);
		
		
	SECONDARY_LIST.setAll(iconValueArray, iconValueArray);
	index = button.getSecondaryIconIndex()
	if( index && iconValueArray.length && index < iconValueArray.length )
		SECONDARY_LIST.setIndex(index);
	else
		SECONDARY_LIST.setIndex(0);
	
	LABEL_INPUT.value = button.getLabelValue();
	DISABLED_CHECK.checked = button.getDisabledValue();
	TEXT_CHECK.checked = button.getTextValue();
}

//--------------------------------------------------------------------
// FUNCTION:
//   updateTag
//
// DESCRIPTION:
//   This function handles all of the user actions triggered by the
//   user from the Propery Inspector controls.
//
// ARGUMENTS:
//  action - string - The name of the action to perform.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------
function updateTag(action)
{
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	if (!canInspectSelection())
		return;
  
	var inputId = selectedNode.id;
  
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
	var button = widgetMgr.getWidget('button', inputId );
	if ( !button )
		return;
    
	if (action) 
	{
		switch (action)
		{
			case "id":
			{
				// Validate the new id.
				var newId = BUTTON_ID.value;
				if ( newId == inputId )
				  return; // Nothing to change.
				
				if ( newId.length == 0 )
				{
				  alert(dw.loadString("jquery/widget/alert/need unique id"));
				  return;
				}
				
				if ( dom.getElementById(newId) )
				{
				  alert(dw.loadString("jquery/widget/alert/id already exists"));
				  return;
				}
				
				if ( !dwscripts.isValidID(newId) )
				{
				  alert(dw.loadString("jquery/widget/alert/id is invalid"));
				  return;
				}
				
				// Update the constructor.
				button.updateWidgetId(newId);

				// Update the WidgetManager for the new ID.
				widgetMgr.setWidget('button', newId, button );
			}
			break;
			
			case 'setLabel':
			{
				button.setLabelValue(LABEL_INPUT.value);
			}
			break;
			case 'setPrimary':
			{
				button.setPrimaryIconIndex(PRIMARY_LIST.getIndex())
			}
			break;
			case 'setSecondary':
			{
				button.setSecondaryIconIndex(SECONDARY_LIST.getIndex())
			}
			case 'setPrimaryString':
			{
				button.setPrimaryIconValue(PRIMARY_LIST.getValue())
			}
			break;
			case 'setSecondaryString':
			{
				button.setSecondaryIconValue(SECONDARY_LIST.getValue())
			}
			break;
			case 'setDisabled':
			{
				button.setDisabledValue(DISABLED_CHECK.checked);
			}
			break;
			case 'setText':
			{
				button.setTextValue(TEXT_CHECK.checked);
			}
			break;
		}
		
   }

	// All these edits modify the Button. We need to recreate the JS Object to reflect those changes.
	button.refresh();

	// Make sure selection stays on the input.
	dom.setSelectedNode(selectedNode); 
	inspectSelection();
}
