/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2010 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
*
**************************************************************************/

var gFreeFontsDir = "FreeFonts/";
var gCurrentJSONFile = "FreeFonts.json";
var gNewJsonFile = "FreeFontsNew.json";
var gNewJSONFiletempFile = gNewJsonFile + "_temp";
var gPathToFonts = dw.getUserConfigurationPath() + gFreeFontsDir;
var gPrevJSONFamilyMap = new Array();
var gNewJSONFamilyMap = new ImageIDContainer();


//Class definition of ImageIDContainer
//It has two arrays, one contains the fontID and other the image URL
//at a given index, the id and imageURL represent same Font Family
function ImageIDContainer() 
{
	this.idArray = new Array();
	this.imageArray = new Array();
	
	this.push = function (id, image) {
		this.idArray.push(id);
		this.imageArray.push(image);
		};
		
	this.checkIDexist = function(id) {
		return this.idArray.indexOf(id) > -1 ? true:false ;
		};
		
	this.getImageForID = function(id) {
		return this.imageArray[this.idArray.indexOf(id)];
		};
}

//Called by DW, it fills in arguments array with arguements sent from CPP layer
function receiveArguments()
{	
	if(arguments[0])
	{
		var command = arguments[0];
		if(command == "DIFF")
		{
			initMaps();
			doDiff();
		}
		else if(command == "VERIFY_TEMP")
		{
			doVerifyTemp();
		}
	}
}

//Goes through both new and old JSON files and creates 
// an array of IDs for old JSON and an ImageIDContainer for updated JSON
function initMaps()
{	
	var fileURL = gPathToFonts + gCurrentJSONFile;
	var fileData= DWfile.read(fileURL);
	if(fileData)
	{
		var JSONData = eval('(' + fileData + ')');
		for (var i = 0; i < JSONData.families.length; i++) 
		{
			gPrevJSONFamilyMap.push(JSONData.families[i].id);
		}
	}
	fileURL = gPathToFonts + gNewJsonFile;
	fileData = DWfile.read(fileURL);
	
	if(fileData)
	{
		JSONData = eval('(' + fileData + ')');
		for (var j = 0; j < JSONData.families.length; j++) 
		{
			gNewJSONFamilyMap.push(JSONData.families[j].id, JSONData.families[j].thumbnails.edge);
		}
	}
}

//Both the structurs are cross verified for fontIDs
// if updated JSON contains extra ID, the imageURL is queued for download
// if current JSOn contains extra ID, the image ID is queued for deletion
function doDiff()
{
	for(var i = 0; i < gNewJSONFamilyMap.idArray.length; i++)
	{
		var id = gNewJSONFamilyMap.idArray[i];
		if( gPrevJSONFamilyMap.indexOf(id)  < 0)
		{	
			dw.addOrDeleteFreeFontImage(id,gNewJSONFamilyMap.getImageForID(id));
		}
	}
	
	for(var j = 0; j< gPrevJSONFamilyMap.length; j++)
	{
		var id = gPrevJSONFamilyMap[j];
		if(!gNewJSONFamilyMap.checkIDexist(id))
		{
			dw.addOrDeleteFreeFontImage(id, "DELETE");
		}
	}
}

function doVerifyTemp()
{
	var fileURL = gPathToFonts + gNewJSONFiletempFile;
	try
	{	
		var fileData= DWfile.read(fileURL);
		if(fileData)
		{
			var JSONData = eval('(' + fileData + ')');
		}
	}
	catch(e)
	{
		DWfile.remove(fileURL);
	}
}