/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'plugin-dependencies',
    'utils/TemplateUtil'
], function ($, _, Backbone, deps, TemplateUtil) {
    "use strict";

    var WaitListView = Backbone.View.extend({
        el: "#results",
        collection: null,
        loading: true,

        initialize: function () {
            this.render();
        },

        render: function () {
            var params = {
                title: deps.translate("WELCOME_EXTRACT"),
                message: deps.translate("BUILDING_EXTRACT_ADDING_NEW_USERS_WILL_NOTIFY_ACCOUNT_ENABLED_FOR_USE") + "<br/><br/>" + 
				deps.translate("THANKS") + "<br/>" + deps.translate("EXTRACT_TEAM")
            };

            this.$el.html(TemplateUtil.createTemplate("#user-waitlisted-template", params));
            return this;
        }
    });
    return WaitListView;
});