
/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, document: true, olark: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'plugin-dependencies',
    'utils/TemplateUtil'
], function ($, _, Backbone, deps, TemplateUtil) {
    'use strict';

    var AlertView = Backbone.View.extend({

        id: 'alert-screen',

        initialize: function () {
            this.render();
            graphite.events.on('load-alert', this.handleLoadAlert, this);
            graphite.events.on('load-report-fidelity-error', this.handleLoadReportFidelityError, this);
        },

        render: function () {
            this.$el.html(TemplateUtil.createTemplate('#alert-screen-template', {type: 'alert', message: deps.translate("UNKNOWN_ERROR")}));
            $('.desktop').append(this.$el);
            this.$el.hide();
        },

        handleLoadAlert: function (message) {
            this.$el.html(TemplateUtil.createTemplate('#alert-screen-template', {type: 'alert', message: message}));
            this.okButtonClick = this.hide;
            this.show();
            // could track a metric here
        },

        handleLoadReportFidelityError: function (message) {
            this.$el.empty();
            this.okButtonClick = this.openOlark;
            this.$el.html(TemplateUtil.createTemplate('#alert-screen-template', {type: 'confirm', message: message}));
            this.show();
            // could track a metric here
        },

        okButtonClick: function (event) {
            this.hide();
        },

        openOlark: function (event) {
            this.hide();
            graphite.events.trigger('report-fidelity-error');
            olark('api.box.expand');
        },

        cancelButtonClick: function (event) {
            this.hide();
            // could track a metric here
        },

        show: function () {
            this.$el.fadeIn(200);
            $(document).on('keydown.alert', $.proxy(this.handleKeyUp, this));
            this.$el.on('click', $.proxy(this.handleClick, this));
        },

        hide: function () {
            this.$el.fadeOut(200);
            $(document).off('keydown.alert');
            this.$el.off('click');
        },

        handleKeyUp: function (event) {
            if (event.keyCode === 27) { //esc key
                this.hide();
            }
        },

        handleClick: function (event) {
            if (event.target.id === 'ok-button') {
                this.okButtonClick();
            } else if (event.target.id === 'cancel-button') {
                this.cancelButtonClick();
            } else if (event.target.id === 'contact-button') {
                this.openOlark();
            } else {
                this.hide();
            }
        }

    });

    return AlertView;
});