/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true, jsonPostObject: true, jsonPostData: true*/

define([
    'jquery',
    'underscore',
    'backbone'
], function ($, _, Backbone) {
    "use strict";

    // serverAPI - ccweb should handle authentication
    var AuthModel = Backbone.Model.extend({

        defaults: {
            access_token: null,
            expires_in: null,
            user_data: null,
            adobeID: null,
            throttled: true
        },

        initialize: function () {
            var that = this;
            // var throttleCheckSuccess = function (data) {
            //     that.throttled = data.throttled;
            // };
            // graphite.serverAPI.throttleCheck(throttleCheckSuccess);

            // var userDataSuccess = function (data) {
            //     that.user_data = data.user_data;
            //     that.adobeID = data.adobeID;
            // };
            // graphite.serverAPI.getUserData(userDataSuccess);
        },

        invalidate: function () {
            this.user_data = null;
        },

        isValid: function () {
            return this.user_data;
        },

        isThrottled: function () {
            return this.throttled;
        },

        isValidWithUserFeature: function (feature) {
            if (this.isValid()) {
                if (this.user_data.accountEnabled) {
                    if (feature) {
                        return (this.user_data[feature] || false);
                    }
                    return true;
                }
            }
            return false;
        },

        isAnalyticsOptIn: function () {
            var isAnalyticsOptIn = true; //by default.

            if (this.user_data) {
                if (!this.user_data.analyticsOptIn) {
                    isAnalyticsOptIn = false;
                }
            }
            return isAnalyticsOptIn;
        },

        isAdobeInternalUser: function () {
            var bAdobeInternal = false;
            if (this.user_data) {
                var emailAddress = this.user_data.email;
                var domainIndex = emailAddress.lastIndexOf("@");
                if (domainIndex !== -1) {
                    var domainName = emailAddress.substr(domainIndex + 1);
                    domainName = domainName.toLowerCase();
                    if ((domainName === "adobe.com") ||
                            (domainName === "adobetest.com") ||
                            (domainName === "601t.com")) {
                        bAdobeInternal = true;
                    }
                }
            }
            return bAdobeInternal;
        },

        setAnalyticsOptIn: function (bAnalyticsOptIn) {
            //post data
            var jsonPostObject = {};
            jsonPostObject.analyticsOptIn = bAnalyticsOptIn;
            var jsonPostData = JSON.stringify(jsonPostObject),
                that = this,
                successFunc = function () {
                    that.user_data.analyticsOptIn = bAnalyticsOptIn;
                },
                errorFunc = function (errMsg) {
                    // we currently do nothing here   
                };

            graphite.serverAPI.setAnalyticsOptIn(jsonPostData, successFunc, errorFunc);
        },

        getAdobeId: function () {
            return this.adobeID;
        },

        getRegisterDate: function () {
            return this.user_data.registerDate;
        }
    });

    return AuthModel;
});
