/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, bitwise: true */
/*global define: true, graphite: true, Image: true, window: true*/

define(['serverAPI'], function (serverAPI) {
    "use strict";

    var ThumbnailController = {
        drawThumbnail: function (model, htmlElem) {
            var assetKey = '',
                modDate = model.get("updated"),
                self = this,
                image;
            
            if (model.get('type') === "application/vnd.adobe.directory+json") {
                assetKey = model.get("id");
            } else {
                assetKey = model.get("md5").replace(/\,/g, "_");
            }
            
            assetKey = assetKey.replace(/\//g, "_");
            image = this[assetKey];
            
            if (image && image.image.complete && image.modDate >= modDate) {
                this.makeDrawFunc(image.image, htmlElem)();
            } else {
                image = {
                    modDate : modDate,
                    image: new Image()
                };

                if (model.get('type') === "application/vnd.adobe.directory+json") {
                    image.image.addEventListener("load", self.makeDrawFunc(image.image, htmlElem));
                    if (model.get("collaboration")) {
                        image.image.src = window.dwData.configPath + 'Floaters/Images/collaborate.png';
                    } else {
                        image.image.src = window.dwData.configPath + 'Floaters/Images/folder.png';
                    }
                    self[assetKey] = image;
                } else {
                    var pathSeparator  = '/',
                        path = "files",
                        md5 = model.get("md5").replace(/\//g, "_").replace(/\,/g, "_"),
                        name = model.get("name");
                    
                    path = window.dwData.configPath + path + pathSeparator;
                    path = path + md5 + pathSeparator + window.dwPSDExtractManager.extractFileNameWithoutExt(name) + ".png";

                    serverAPI.downloadWebAsset(graphite.serverAPI.getAssetThumbnailUrl(name), function (imgurl) {
                        image.image.addEventListener("load", self.makeDrawFunc(image.image, htmlElem));
                        image.image.src = imgurl;
                        self[assetKey] = image;
                    }, path);
                }
            }
        },

        makeDrawFunc: function (image, htmlElem) {
            var theImage = image,
                theElem = htmlElem;

            return function () {
                theElem.width = image.width;
                theElem.height = image.height;
                var context = theElem.getContext("2d");
                context.drawImage(theImage, 0, 0);
            };
        }
    };

    return ThumbnailController;
});
