/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/controllers/SelectionController',
    'ccweb.files.extract/controllers/ZoomController',
    'DWPSDExtractSelectionHandler',
    'ccweb.files.extract/utils/MeasurementUtil',
    'parfait/SelectionOverlayView'
], function ($, _, Backbone, SelectionController, ZoomController, DWPSDExtractSelectionHandler, MeasurementUtil, SelectionOverlayView) {
    'use strict';
    var DwSelectionOverlayView = SelectionOverlayView.extend({
            message: {
                ADD_HOVER: "ADD HOVER",
                REMOVE_HOVER: "REMOVE HOVER",
                ADD_SELECTION: "ADD SELECTION",
                REMOVE_SELECTION: "REMOVE SELECTION"
            },
        
            initialize: function (options) {
                _.bindAll(this, 'handleSelectionChange', 'handleHoverOver');
                this.parentView = options.parentView;
                this.render();
                graphite.events.on("selection-changed", this.handleSelectionChange, this);
                graphite.events.on("item-hovered-over", this.handleHoverOver, this);
                graphite.events.on("zoomChanged", this.handleZoomChanged, this);
                this.hoverArray = null;
            },
        
            drawOutline: function (layerModel, className) {
                var newOutlineRect,
                    outlineOffset,
                    overlayWidth = this.$el.width(),
                    overlayHeight = this.$el.height(),
                    isEdgeAdjacent,
                    bounds;

                //Show the selection rects
                bounds = MeasurementUtil.getVisibleBounds(layerModel, SelectionController.getPSDModel());
                bounds = ZoomController.zoomRect(bounds);

                // Inset outline if our layerModel is adjacent
                // to our overlay edge.
                isEdgeAdjacent = bounds.top <= 0 ||
                    bounds.left <= 0 ||
                    bounds.right >= overlayWidth ||
                    bounds.bottom >= overlayHeight;
                outlineOffset = isEdgeAdjacent ? -1 : 0;

                var message = {type: ""};
                if (className === "hover") {
                    message.type = this.message.ADD_HOVER;
                } else if (className === "selection") {
                    message.type = this.message.ADD_SELECTION;
                }
                if (message.type) {
                    var styleCSSString = "";
                    styleCSSString += '-webkit-transform: translate3d(' + bounds.left + 'px,' + bounds.top + 'px, 0);';
                    styleCSSString += "height:" + (bounds.bottom - bounds.top) + "px;";
                    styleCSSString += "width:" + (bounds.right - bounds.left) + "px;";
                    styleCSSString += "outline-offset:" + outlineOffset + "px;";
                    message.css = styleCSSString;
                    this.sendMessageToOverlayIframe(message);
                }
            },

            sendMessageToOverlayIframe: function (message) {
                var iframeWin = document.getElementById("selection-overlay");
                if (iframeWin) {
                    iframeWin = iframeWin.contentWindow;
                    if (iframeWin) {
                        iframeWin.postMessage(message, "*");
                    }
                }
            },

            handleSelectionChange: function () {
                var newSelection = SelectionController.getSelectedLayers(),
                    i,
                    j;

                // first remove all the existing buttonbars
                // (if performance becomes an issue we can recycle existing buttonbars)
                for (i = 0; i < this.selectionButtonBars.length; i++) {
                    this.selectionButtonBars[i].remove();
                }

                this.selectionButtonBars = [];
                var message = {type: this.message.REMOVE_SELECTION};
                this.sendMessageToOverlayIframe(message);

                for (j = 0; j < newSelection.length; j++) {
                    this.drawOutline(newSelection[j], 'selection');
                }
                DWPSDExtractSelectionHandler.updateSelection(newSelection);
            },

            handleZoomChanged: function () {
                var message = {type: this.message.REMOVE_HOVER};
                this.sendMessageToOverlayIframe(message);
                var lastSelectedLayers = SelectionController.getSelectedLayers();
                SelectionController.changeSelection([], false, true);
                graphite.events.once('zoomCompleted', function () {
                    if (!SelectionController.getSelectedLayers().length) {
                        SelectionController.changeSelection(lastSelectedLayers, false, true);
                    }
                });
            },

            equalArrays: function (array1, array2) {
                // if any array is a falsy value, return
                if (!array1 || !array2) {
                    return false;
                }

                // compare lengths - can save a lot of time 
                if (array1.length !== array2.length) {
                    return false;
                }

                var i = 0,
                    len = array1.length;

                for (i; i < len; i++) {
                    if (array1[i].get("layerId") !== array2[i].get("layerId")) {
                        return false;
                    }
                }
                return true;
            },

            handleHoverOver: function (hoverArray) {
                if (!this.equalArrays(this.hoverArray, hoverArray)) {
                    var i,
                        message = {type: this.message.REMOVE_HOVER};
                    this.sendMessageToOverlayIframe(message);

                    for (i = 0; i < hoverArray.length; i++) {
                        if (!this.isItemSelected(hoverArray[i])) {
                            this.drawOutline(hoverArray[i], "hover");
                        }
                    }
                    this.hoverArray = hoverArray;
                }
            },

            remove: function () {
                this.$el.find("iframe").attr('src', '');
                this.$el.find("iframe").remove();
                this.removeEventListeners();
                if (this.hoverArray && this.hoverArray.length) {
                    this.hoverArray.length = 0;
                    this.hoverArray = null;
                }
                return Backbone.View.prototype.remove.apply(this, arguments);
            }
        });
    
    return DwSelectionOverlayView;
});