/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/Constants',
    'ccweb.files.extract/views/popup/BasePreviewPopupView',
    'ccweb.files.extract/controllers/ZoomController',
    'ccweb.files.extract/controllers/ClipboardController',
    'ccweb.files.extract/models/PSDSettingsModel',
    'ccweb.files.extract/models/UserSettingsModel',
    'ccweb.files.extract/utils/TemplateUtil',
	'DWPSDExtractManager',
	'plugin-dependencies',
    'text!ccweb.files.extract/views/templates/measurementOffsetsBoxTemplate.html',
    'text!ccweb.files.extract/views/templates/measurementOffsetsBannerTemplate.html',
    'parfait/MeasurementOffsetPopupView'
], function ($, _, Backbone, Constants, BasePreviewPopupView, ZoomController, ClipboardController, PSDSettingsModel,
             UserSettingsModel, TemplateUtil, DWPSDExtractManager, deps, MeasurementOffsetsBoxTemplate, MeasurementOffsetsBannerTemplate, MeasurementOffsetPopupView) {

    'use strict';

    var DwMeasurementOffsetPopupView = MeasurementOffsetPopupView.extend({
        tooltipBounds: null,
        
        showSuccessTooltip: function (message) {
            if (this.tooltipBounds) {
                var parent = this.$el.parent().get(0);
                $(parent).append("<div id='notificationTooltip' style='display:none'><span>" + message + "</span></div>");
                var tooltip = $("#notificationTooltip");
                var tipWidth = tooltip.width();
                var tipHeight = tooltip.height();
                var elementBounds = this.tooltipBounds;
                var tipPosLeft = ((elementBounds.left + (elementBounds.right - elementBounds.left) / 2)) - tipWidth / 2;
                var tipPosTop = ((elementBounds.top + (elementBounds.bottom - elementBounds.top) / 2)) - tipHeight / 2;
                tooltip.css({top: tipPosTop, left: tipPosLeft, opacity: 0.8});
                tooltip.fadeIn(250);
                setTimeout(function () {
                    tooltip.remove();
                }, Constants.toolTipTimeout);
            }
        },
        
        copyDimensionCss: function (e) {
            var targetElement = $(e.target),
                dimensionValue = NaN,
                units = UserSettingsModel.get('preferredMeasurementUnits'),
                classValue;

            if (targetElement.hasClass('copyable')) {
                if (targetElement.parent()[0].id === "measurementOffsetsBanner") {
					graphite.events.trigger("dimensions-multiSelect-used");
                }
                dimensionValue = parseFloat(targetElement.text(), 10);
                
            } else {
                classValue = targetElement.attr('class');
                if (classValue.indexOf('OffsetIcon') !== -1) {
                    dimensionValue = parseFloat(targetElement.parent().text(), 10);
                }
            }
            if (!isNaN(dimensionValue)) {
                DWPSDExtractManager.copyCSS(dimensionValue + units);
                this.showSuccessTooltip(deps.translate("VALUE_COPIED_TO_CLIPBOARD"));
            }
        },
        
        handleShowMeasurementInfo: function (params) {
            if (params.containerBounds) {
                this.tooltipBounds = ZoomController.zoomRect(params.containerBounds);
            }
            this.showParams = $.extend(true, {}, params); //do a deep clone of the params object
            if (params.bounds) {
                graphite.events.trigger('show-measurement-offsets');

                var $measurementOffsetsBox = this.$el.find('#measurementOffsetsBox');

                //The incoming bounds parameters were values that were scaled to the zoom level. This led to rounding
                //errors in the displayed values because they were zoomed and unzoomed. To fix this I changed the bounds
                //parameters to unzoomed values, so now we have to change to zoomed values here so the popup
                //and the offset rectangle & arrows are drawn on the correct position
                //Mark R 07/14/15
                var zoomedBounds = ZoomController.zoomRect(params.bounds);

                // Account for box-sizing:border-box 1px border
                var canvasWidth = zoomedBounds.width - 2;
                var canvasHeight = zoomedBounds.height - 2;

                //Show the pre-calculated offsets between two elements
                //Size the div to the bounds parameter
                $measurementOffsetsBox.css({'top': zoomedBounds.top + 'px', 'left': (zoomedBounds.left) + 'px',
                                            'height': Math.max(1, canvasHeight), 'width': Math.max(1, canvasWidth)});
                var $drawingCanvas = this.$el.find('#measurementOffsetsCanvas');
                $drawingCanvas[0].width = Math.max(1, zoomedBounds.width);
                $drawingCanvas[0].height = Math.max(1, zoomedBounds.height);

                var drawingContext = $drawingCanvas[0].getContext('2d');
                this.$el.show();

                drawingContext.lineWidth = 1;
                drawingContext.strokeStyle = '#000';
                var arrowheadSize = 3;

                var midX = Math.floor(canvasWidth / 2) + 0.5;
                var midY = Math.floor(canvasHeight / 2) + 0.5;

                drawingContext.moveTo(0, midY);

                //Only draw the horizontal arrow line if there is room for it
                if (canvasHeight >= 5) {
                    //Draw the left arrowhead if there is room for it
                    if (canvasWidth > (arrowheadSize + 3) * 2) {
                        drawingContext.lineTo(arrowheadSize, midY - arrowheadSize);
                        drawingContext.stroke();
                        drawingContext.moveTo(0, midY);
                        drawingContext.lineTo(arrowheadSize, midY + arrowheadSize);
                        drawingContext.stroke();
                        drawingContext.moveTo(0, midY);
                    }

                    drawingContext.lineTo(canvasWidth, midY);
                    drawingContext.stroke();

                    //Draw the right arrowhead if there is room for it
                    if (canvasWidth > (arrowheadSize + 3) * 2) {
                        drawingContext.lineTo(canvasWidth - arrowheadSize, midY - arrowheadSize);
                        drawingContext.stroke();
                        drawingContext.moveTo(canvasWidth, midY);
                        drawingContext.lineTo(canvasWidth - arrowheadSize, midY + arrowheadSize);
                        drawingContext.stroke();
                    }
                }

                //Only draw the vertical arrow line if there is room for it
                if (canvasWidth >= 5) {
                    //Draw the top arrowhead if there is room for it
                    if (canvasHeight > (arrowheadSize + 3) * 2) {
                        drawingContext.moveTo(midX, 0);
                        drawingContext.lineTo(midX - arrowheadSize, arrowheadSize);
                        drawingContext.stroke();
                        drawingContext.moveTo(midX, 0);
                        drawingContext.lineTo(midX + arrowheadSize, arrowheadSize);
                        drawingContext.stroke();
                    }

                    drawingContext.moveTo(midX, 0);
                    drawingContext.lineTo(midX, canvasHeight);
                    drawingContext.stroke();

                    //Draw the bottom arrowhead if there is room for it
                    if (canvasHeight > (arrowheadSize + 3) * 2) {
                        drawingContext.lineTo(midX - arrowheadSize, canvasHeight - arrowheadSize);
                        drawingContext.stroke();
                        drawingContext.moveTo(midX, canvasHeight);
                        drawingContext.lineTo(midX + arrowheadSize, canvasHeight - arrowheadSize);
                        drawingContext.stroke();
                    }
                }

                //Draw the offset info banner with the correct values
                $measurementOffsetsBox.append(
                    TemplateUtil.createTemplate(MeasurementOffsetsBannerTemplate)
                );

                var copyables = this.$el.find('.copyable');
                
                this.updateMeasurementDisplay();
				var self = this;

                var $banner = this.$el.find('#measurementOffsetsBanner');
                $banner.click(function (e) {
                    self.copyDimensionCss(e);
                    e.stopPropagation();
                });

                //Check where the banner box will fit and place it
                var notch = this.$el.find('.notch');
                notch.show();
                var bannerLeft = (canvasWidth - $banner.outerWidth()) / 2;
                if (bannerLeft + params.bounds.left < 0) {
                    bannerLeft = params.bounds.left;
                }
                var bannerTop = 0;
                if ((canvasWidth >= ($banner.outerWidth() + (arrowheadSize + 3) * 2)) &&
                        (canvasHeight >= ($banner.outerHeight() + (arrowheadSize + 3) * 2))) {
                    //The banner fits inside, place it in the center of the box
                    bannerTop = (canvasHeight - $banner.outerHeight()) / 2;
                    notch.hide();
                } else {
                    //Place the banner outside the box, above or below
                    bannerTop = canvasHeight + 6;
                    if (bannerTop + $banner.outerHeight() > $('#selection-overlay').height()) {
                        bannerTop = -$banner.outerHeight() - 6;
                    }
                }
                $banner.css({top: bannerTop + 'px', left: bannerLeft + 'px'});

                //center notch on the popup
                var notchWidth = 20; //Hardcode the width rather than try to calculate the length of the triangle base
                var notchx = ($banner.outerWidth() - notchWidth) / 2;
                notch.css({left: notchx, top: '-6px'});
            } else {
                this.closePopup();
            }
        },
        
        updateMeasurementDisplay: function () {
            var params = $.extend(true, {}, this.showParams),
                preferredMeasurementUnits = UserSettingsModel.get('preferredMeasurementUnits'),
                designedAtMultiplier = PSDSettingsModel.get('designedAtMultiplier');

            if (preferredMeasurementUnits === Constants.MeasurementUnitType.PCT) {
                //Convert the pixel values to percent
                params.containerBounds.width = params.containerBounds.right - params.containerBounds.left;
                params.containerBounds.height = params.containerBounds.bottom - params.containerBounds.top;
                params.bounds.width = +(params.bounds.width / params.containerBounds.width * 100).toFixed(1);
                params.bounds.height = +(params.bounds.height / params.containerBounds.height * 100).toFixed(1);
            } else {
                params.bounds.width = Math.round(params.bounds.width / designedAtMultiplier);
                params.bounds.height = Math.round(params.bounds.height / designedAtMultiplier);
            }

            this.$el.find('#measurementOffsetX').html('<i class="xOffsetIcon"></i>' + params.bounds.width + preferredMeasurementUnits);
            this.$el.find('#measurementOffsetY').html('<i class="yOffsetIcon"></i>' + params.bounds.height + preferredMeasurementUnits);
        }
    });
    
    return DwMeasurementOffsetPopupView;
});