/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, InspectCSSView: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/models/ColorModel',
    'ccweb.files.extract/models/UserSettingsModel',
    'ccweb.files.extract/controllers/SelectionController',
    'ccweb.files.extract/views/inspect/CSSListItemView',
    'ccweb.files.extract/utils/CSSUtil',
    'ccweb.files.extract/utils/TemplateUtil',
    'text!ccweb.files.extract/views/templates/cssColorItemTemplate.html',
    'text!ccweb.files.extract/views/templates/messageSelectSingleItemTemplate.html',
    'parfait/InspectCSSView'
], function ($, _, Backbone, ColorModel, UserSettingsModel, SelectionController, CSSListItemView, CSSUtil, TemplateUtil,
             CSSColorItemTemplate, MessageSelectSingleItemTemplate, InspectCSSView) {
    'use strict';
    var DwInspectCSSView = InspectCSSView.extend({
        defaults: {
            parentView: null,
            cssListItemViews: [],
            $messageEl: null
        },
        
        initialize: function (options) {
            this.parentView = options.parentView;
            this.cssListItemViews = [];
            //story the message element
            this.$messageEl = $(TemplateUtil.createTemplate(MessageSelectSingleItemTemplate));
            this.render();
            this.addHandlers();

            graphite.events.on('designedAtMultiplierChanged', this.refreshCSS, this);
        },
        
        render: function () {
            var psdModel = SelectionController.getPSDModel(),
                localContent = psdModel.get('localContent');

            this.handleSelectionChange();
        },
        
        refreshCSS: function () {
            var selectedLayers = SelectionController.getSelectedLayers(),
                cssContainer = $(this.parentView.el).find('.css-properties'),
                preProcessor = UserSettingsModel.get('preprocessor'),
                layerModel,
                cssProperties,
                i,
                listItemView;

            // only populate the list if one layer is selected
            if (selectedLayers.length === 1) {
                layerModel = selectedLayers[0];
                // If we are using a preprocessor, we don't need vendor prefixes
                cssProperties = layerModel.getCSSArray(preProcessor === 'css');

                //TODO: we may want to sort the properties in a certain order?

                this.clearCSSList();
                for (i = 0; i < cssProperties.length; i++) {
                    listItemView = new CSSListItemView({cssObj: cssProperties[i], preProcessor: preProcessor});
                    this.cssListItemViews.push(listItemView);
                    cssContainer.append(listItemView.el);
                }
            } else {
                this.clearCSSList();
                this.displayMessages();
            }
        },

        handleNewDropperColor: function (extractedColor) {
            var colorModel = new ColorModel(extractedColor),
                $cssContainer = $(this.parentView.el).find('.css-properties'),
                alpha = extractedColor.alpha < 1 ? extractedColor.alpha.toFixed(2) : null,
                colorEl;
            $cssContainer.empty();
            colorEl = TemplateUtil.createTemplate(CSSColorItemTemplate, {value: colorModel.toHEXString()});
            $cssContainer.append(colorEl);
            colorEl = TemplateUtil.createTemplate(CSSColorItemTemplate, {value: colorModel.toRGBString(alpha)});
            $cssContainer.append(colorEl);
            colorEl = TemplateUtil.createTemplate(CSSColorItemTemplate, {value: colorModel.toHSLString(alpha)});
            $cssContainer.append(colorEl);
        },

        clearCSSList: function () {
            var i,
                listItem,
                $cssContainer = $(this.parentView.el).find('.css-properties');

            for (i = this.cssListItemViews.length - 1; i !== -1; i--) {
                listItem = this.cssListItemViews.pop();
                listItem.remove();
            }

            //remove the message element
            this.$messageEl.remove();
            $cssContainer.empty();

            SelectionController.clearDOMSelection();
        },

        displayMessages: function () {
            var selectedLayers = SelectionController.getSelectedLayers(),
                cssContainer = $(this.parentView.el).find('.css-properties');

            //if no layer is selected or more than one layer is selected display the same message
            if ((selectedLayers.length === 0) ||
                    (selectedLayers.length > 1)) {
                cssContainer.append(this.$messageEl);
            }
        }
    });
    
    return DwInspectCSSView;
});