/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/controllers/ClipboardController',
    'ccweb.files.extract/models/TextStyleUsageModel',
    'ccweb.files.extract/models/UserSettingsModel',
    'ccweb.files.extract/models/GradientUsageModel',
    'ccweb.files.extract/views/popup/BasePopupView',
    'ccweb.files.extract/utils/CSSUtil',
    'ccweb.files.extract/utils/TemplateUtil',
    'dreamweaver/models/CopyCssPopupModel',
    'dreamweaver/views/CopyCssPopupView',
    'ccweb.files.extract/controllers/SelectionController',
    'text!ccweb.files.extract/views/templates/extractCodeTemplate.html',
    'DWPSDExtractManager',
    'plugin-dependencies'
], function ($, _, Backbone, ClipboardController, TextStyleUsageModel,
             UserSettingsModel, GradientUsageModel, BasePopupView, CSSUtil,
              TemplateUtil, CopyCssPopupModel, CopyCssPopupView, SelectionController,
              ExtractCodeTemplate, DWPSDExtractManager, deps) {
    "use strict";

    var StylesPopupView = BasePopupView.extend({

        className: "extract-code-popup popup",

        copyString: deps.translate("COPY_CSS"),
        copiedString: deps.translate("COPIED"),
        viewMoreString: deps.translate("VIEW_MORE"),
        viewLessString: deps.translate("VIEW_LESS"),

        events: {
            "click .copyable-button": "handleSelectClick",
            "dblclick .topcoat-textarea": "handleDoubleClickEvent"
        },

        initialize: function () {
            BasePopupView.prototype.initialize.apply(this, arguments);

            // events
            graphite.events.on("show-extract-code-popup", this.handleShow, this);
            graphite.events.on("hide-extract-code-popup", this.closePopup, this);
        },

        render: function () {
            BasePopupView.prototype.render.apply(this, arguments);

            this.$el.find('.popup-contents').html(TemplateUtil.createTemplate(ExtractCodeTemplate));

            this.$actionButton = this.$el.find(".copyable-button");
            this.$actionButton.html(this.copyString);
            this.$actionButton.attr("title", deps.translate("CLICK_TO_COPY"));
            this.addHandlers();
            return this;
        },
        
        addHandlers: function () {
            var copyButton = this.$el.find("copyCSSLink"),
                mouseEnter = function () {
                    $(this).data('title', $(this).attr('title'));
                    $(this).removeAttr('title');
                },
                mouseLeave = function () {
                    $(this).attr('title', $(this).data('title'));
                };
            window.graphite.events.on("disable-css-copy", function () {
                if (this.copyCssPopupModel && this.copyCssPopupModel.get("isDisabled")) {
                    this.$actionButton.addClass("disabled");
                    this.$actionButton.hover(mouseEnter, mouseLeave);
                }
            }, this);
            window.graphite.events.on("enable-css-copy", function () {
                if (this.copyCssPopupModel && !this.copyCssPopupModel.get("isDisabled")) {
                    this.$actionButton.unbind('mouseenter', mouseEnter).unbind('mouseleave', mouseLeave);
                    this.$actionButton.removeClass("disabled");
                }
            }, this);
        },
        
        getFilteredElementCss: function () {
            var cssString = '',
                propertyName = '',
                propertyValue = '';
            Array.prototype.slice.call(this.$el.find('.css-property-item'), 0).forEach(function (cssItemNode) {
                if ($(cssItemNode).find('.copy-css-check').length === 0 || $(cssItemNode).find('.copy-css-check').is(':checked')) {
                    propertyName = $(cssItemNode).find('.property-name').text();
                    propertyValue = $(cssItemNode).find('.property-value').text();
                    if (propertyName && propertyValue) {
                        cssString += propertyName + ': ' + propertyValue + ';\n';
                    }
                }
            });
            
            // Remove extra \n in the end
            return cssString.slice(0, cssString.length - 1);
        },
        
        handleSelectClick: function () {
            if (this.copyCssPopupModel && !this.copyCssPopupModel.get("isDisabled")) {
                var cssStr = this.getFilteredElementCss();
                var params = {};
                if (this.source.hasClass("text-style-size")) {
                    graphite.events.trigger("css-copy-fonts");
                } else if (this.source.hasClass("color-chip")) {
                    graphite.events.trigger("css-copy-gradients");
                }

                var gradientVendorPrefixes = this.copyCssPopupModel.get('vendorSpecificGradients');
                var gradientVendorPrefixesString = '';
                if (gradientVendorPrefixes && gradientVendorPrefixes.length > 0) {
                    var idx;
                    for (idx = 0; idx < gradientVendorPrefixes.length; idx++) {
                        var grad = gradientVendorPrefixes[idx];
                        if (grad.property) {
                            gradientVendorPrefixesString += grad.property + ': ' + grad.value + ';\n';
                        }
                    }
                }

                DWPSDExtractManager.copyCSS(cssStr, gradientVendorPrefixesString);
                graphite.events.trigger("css-copied-in-styles", "div.extract-code-popup", deps.translate("CSS_COPIED_TO_CLIPBOARD"));
            }
        },

        initCopyToClipboard: function () {
            ClipboardController.getClipboard().clip(this.$actionButton);
            graphite.events.on("clipboard-loaded", this.handleClipboardLoaded, this);
            graphite.events.on("clipboard-data-requested", this.handleClipboardDataRequest, this);
            graphite.events.on("clipboard-complete", this.handleClipboardComplete, this);
            graphite.events.on("clipboard-mouseover", this.handleClipboardMouseOver, this);
        },
      
        renderCssGroups: function (model, sourceElement) {
            var cssProperties = model.get("style").getCSS(true),
                firstGradientItem,
                vendorPrefixedGrads = [];
            
            // Filter out redundant css for gradients
            if (cssProperties.length >= 0 && (cssProperties[cssProperties.length - 1].value.indexOf('linear-gradient') !== -1 ||
                                              cssProperties[cssProperties.length - 1].value.indexOf('radial-gradient') !== -1)) {
                
                // First copy all of the vendor prefixes
                var idx;
                for (idx = 0; idx < cssProperties.length; idx++) {
                    var grad = cssProperties[idx];
                    if (grad.property === 'background') {
                        grad.property = 'background-image';
                    }
                    
                    vendorPrefixedGrads.push(grad);
                    
                }
              
                firstGradientItem = cssProperties[cssProperties.length - 1];
                if (firstGradientItem.property === 'background') {
                    firstGradientItem.property = 'background-image';
                }
                
                cssProperties = [firstGradientItem];
            }
            
            if (!this.copyCssPopupModel) {
                this.copyCssPopupModel = new CopyCssPopupModel();
            }
            this.copyCssPopupModel.set('cssArray', cssProperties);
            this.copyCssPopupModel.set('vendorSpecificGradients', vendorPrefixedGrads);
            this.copyCssPopupModel.createCssStructures();
            if (this.cssGroupView) {
                this.cssGroupView.remove();
                this.cssGroupView = null;
            }
            this.cssGroupView = new CopyCssPopupView({model: this.copyCssPopupModel});
            
            // Clear existing html and add new popup content.
            // Also make some styling changes as this popup appears
            // different from the selection copy css popup
            this.$el.find('#copy-css-groups-container').html('');
            this.$el.find('#copy-css-groups-container').css('margin-top', '27px');
            this.cssGroupView.$el.find('input[type="checkbox"]').css('vertical-align', 'sub');
            this.$el.find('#copy-css-groups-container').append(this.cssGroupView.el);
			this.$el.find('#copy-css-groups-container > div:first-child').addClass(sourceElement.attr("class"));
        },

        //------------------------------------------------
        // Handlers
        //------------------------------------------------

        handleClipboardLoaded: function () {
            this.$actionButton.addClass("clipboard-enabled");
        },

        handleClipboardDataRequest: function (elem) {
            var clip = ClipboardController.getClipboard();
            if (elem === this.$actionButton[0]) {
                clip.setText(this.$el.find("textarea").text());
                graphite.events.trigger('copy-css', {origin: 'StylesPopup'});
            }
        },

        handleClipboardComplete: function () {
            this.$actionButton.html(this.copiedString);
        },

        handleClipboardMouseOver: function () {
            this.isMouseOver = true;
        },

        handleShow: function (params) {
            this.renderCssGroups(params.model, params.sourceElement);
            BasePopupView.prototype.handleShow.apply(this, arguments);

            
        },
        
        remove: function () {
            if (this.copyCssPopupModel) {
                this.copyCssPopupModel.destroy();
                this.copyCssPopupModel = null;
            }
            if (this.cssGroupView) {
                this.cssGroupView.remove();
                this.cssGroupView = null;
            }

            BasePopupView.prototype.remove.apply(this, arguments);
        }
    });

    return StylesPopupView;
});
