
/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, document: true, olark: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'plugin-dependencies',
    'dreamweaver/controllers/DwNetworkStatusController',
    'utils/TemplateUtil',
    'DWPSDExtractManager'
], function ($, _, Backbone, deps, DwNetworkStatusController, TemplateUtil, DWPSDExtractManager) {
    'use strict';

    var FirstScreenView = Backbone.View.extend({
        events: {
            "click #refreshButton": "handleRefreshButtonClick"
           
        },
        
        initialize: function () {
            Backbone.View.prototype.initialize.apply(this, arguments);
            window.graphite.events.on("netstatus-change", this.notifyUser, this);
            if (navigator.onLine) {
                this.currentNotification = "connected";
            } else {
                this.currentNotification = "disconnected";
            }
            window.graphite.events.on("authstatus-change", this.processAuthStatusCode, this);
            this.render();
        },
        
        remove: function () {
            // COMPLETELY UNBIND THE VIEW
            window.graphite.events.off("netstatus-change", this.notifyUser, this);
            window.graphite.events.off("authstatus-change", this.processAuthStatusCode, this);
            this.$notification.find('#creative-cloud-link').off('click');
            this.undelegateEvents();
            this.$el.removeData().unbind();
            Backbone.View.prototype.remove.call(this);
        },
        
        fetchNotificationMessage : function (notification) {
            var messageText = "";
            
            if (typeof notification !== undefined && notification !== null) {
                if (notification === "disconnected") {
                    messageText = deps.translate("NOTIFICATION_OFFLINE_CONNECT_TO_CREATIVE_CLOUD");
                } else if (notification === "connected") {
                    messageText = deps.translate("WELCOME_EXTRACT");
                } else if (notification === "generic_error") {
                    messageText = deps.translate("GENERIC_ERROR");
                } else if (notification === "trial_no_login_error") {
                    messageText = deps.translate("TRIAL_NO_LOGIN_ERROR");
                } else if (notification === "normal_user_noaccess_error") {
                    messageText = deps.translate("UNAUTHORISED_NORMAL_USER");
                } else if (notification === "enterprise_user_noaccess_error") {
                    messageText = deps.translate("UNAUTHORISED_ENTERPRISE_USER");
                }
            }
            
            return messageText;
        },
        
        notifyUser: function (notification) {
            //When we get the reconnect message, just refresh and return.
            if (notification === "reconnected") {
                this.handleRefreshButtonClick();
                return;
            }
            var messageText = this.fetchNotificationMessage(notification);
            if (this.$notification) {
                if (this.currentNotification !== notification) {
                    // Notification text can also be html to enable links
                    this.$notification.html(messageText);
                    if (notification === "disconnected") {
                        this.$refreshButton.removeClass("hide").addClass("show");
                    } else {
                        this.$refreshButton.removeClass("show").addClass("hide");
                    }
                    this.$notification.find('#creative-cloud-link').on('click', function () {
                        DWPSDExtractManager.openInBrowser('www.adobe.com');
                    });
                }
            }
            this.currentNotification = notification;
            this.$el.removeClass("hide").addClass("show");
        },
        
        handleRefreshButtonClick: function () {
            DWPSDExtractManager.refreshPanel();
        },
        processAuthStatusCode: function (statusCode, isType1User) {
            //taken from NGLStatusCode.h, must match IMS_ERROR_ACCT_ACT_REQ and IMS_ERROR_SUBS_ACT_REQ
            var ACCT_ACT_REQ_NGL_STATUS_CODE = 313;
            var SUBS_ACT_REQ_NGL_STATUS_CODE = 315;

            switch (+statusCode) {
            case 0:
                break;
            case SUBS_ACT_REQ_NGL_STATUS_CODE:
                if (isType1User) {
                    this.notifyUser("normal_user_noaccess_error");
                } else {
                    this.notifyUser("enterprise_user_noaccess_error");
                }
                break;
            case ACCT_ACT_REQ_NGL_STATUS_CODE:
                this.notifyUser("trial_no_login_error");
                break;
            default:
                this.notifyUser("generic_error");
                break;
            }
        },
        //------------------------------------------------
        // Render
        //------------------------------------------------

        render: function () {
                
            var messageText = this.fetchNotificationMessage(this.currentNotification);
            
            var tmpl = TemplateUtil.createTemplate("#netstatus-firstscreen-template", {"messageText" : messageText});
            $("#launchContainer").append(tmpl);
            this.setElement("#netstatus-firstscreen");
            
            this.$notification = this.$el.find(".netstatus-notification-nowrap #view-notification-message");
            this.$refreshButton = this.$el.find("#refreshButton");
            if (this.currentNotification === "connected") {
                this.$refreshButton.removeClass("show").addClass("hide");
            } else {
                this.$refreshButton.removeClass("hide").addClass("show");
            }
            return this;
        }

    });
    return FirstScreenView;
});
