/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'parfait/SelectionBarView',
    'ccweb.files.extract/controllers/DetailsController',
    'ccweb.files.extract/Constants',
    'plugin-dependencies',
    'ccweb.files.extract/utils/TemplateUtil',
    'text!ccweb.files.extract/views/templates/toolbarTemplate.html',
    'ccweb.files.extract/views/detail/LayerCompView',
    'ccweb.files.extract/views/detail/ZoomView'
], function ($, _, Backbone, SelectionBarView, DetailsController, Constants, deps, TemplateUtil, ToolbarTemplate, LayerCompView, ZoomView) {
    "use strict";

    var DwSelectionBarView = SelectionBarView.extend({
        events: function () {
            return _.extend({}, SelectionBarView.prototype.events, {
                "click .arrow-right": "handleRightArrowClick",
                "click .keyboard-shortcut-guide": "handleKeyboardShortcutGuideClick",
                "click .arrow-left": "handleLeftArrowClick"
            });
        },
        
        initialize: function () {
            this.bToggleMeasurementKeyDown = false;

            this.render();

            DetailsController.on("change:toggleMeasurementOnHover", this.handleMeasurementToggleChange, this);
            DetailsController.on("panelMoved", this.zoomAsNeeded, this);
        },
        
        handleKeyboardShortcutGuideClick: function () {
            graphite.events.trigger("toggle-help-dialog");
        },

        render: function () {
            var labels = {
                regularSelect: deps.translate("REGULAR_SELECT"),
                directSelect: deps.translate("DIRECT_SELECT"),
                showMeasurementsOnHover: deps.translate("TOGGLE_SHOW_INFO_HOVER")
            };
            this.setElement(TemplateUtil.createTemplate(ToolbarTemplate, labels));

            this.zoomControlsView = new ZoomView();
            this.$el.prepend(this.zoomControlsView.$el);
            this.layerCompControlsView = new LayerCompView();
            this.$el.prepend(this.layerCompControlsView.$el);
            return this;
        },
        
        remove: function () {
            this.zoomControlsView.remove();
            this.zoomControlsView = null;
            this.layerCompControlsView.remove();
            this.layerCompControlsView = null;
            this.removeEventListeners();
            Backbone.View.prototype.remove.call(this);
        },
        
        handleActiveToolChange: function () {
            var newTool = DetailsController.get('activeTool');
            $(this.el).find('button').removeClass('active');

            switch (newTool) {
            case Constants.Tool.SELECT_DIRECT:
                $(this.el).find(".direct-select ").addClass("active");
                graphite.events.trigger('activeTool', {activeTool: deps.translate("DIRECT_SELECT")});
                break;
            case Constants.Tool.SELECT_REGULAR:
                $(this.el).find(".regular-select ").addClass("active");
                graphite.events.trigger('activeTool', {activeTool: deps.translate("REGULAR_SELECT")});
                break;
            default:
                console.log('Invalid Tool activated');
            }
        },
        
        zoomAsNeeded: function () {
            if (this.zoomControlsView) {
                this.zoomControlsView.handleZoomToFitClick();
            }
        }
        
    });
    
    return DwSelectionBarView;
});