
/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, document: true, olark: true, window: true, setTimeout: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'plugin-dependencies',
    'dreamweaver/controllers/DwNetworkStatusController',
    'utils/TemplateUtil'
], function ($, _, Backbone, deps, DwNetworkStatusController, TemplateUtil) {
    'use strict';

    var DwConnectionAlertToolbarView = Backbone.View.extend({
        
        errorTypes: [
            "WARNING",
            "ERROR_DOWNLOAD_FAILED",
            "ERROR_FILE_WRITE_FAILED"
        ],
        currentDisplayErrorPriority: -1,
        
        initialize: function () {
            var self = this;
            Backbone.View.prototype.initialize.apply(this, arguments);
            window.graphite.events.on("netstatus-change", this.notifyNetStatusChange, this);
            window.graphite.events.on("bad-file-type-upload", this.notifyBadFileUploadError, this);
            window.graphite.events.on("valid-file-upload-error", this.notifyValidFileUploadError, this);
            window.graphite.events.on("duplicate-file-upload-error", this.notifyDuplicateFileUploadError, this);
            window.graphite.events.on("fetch-extract-data-error", this.notifyExtractDataFetchError, this);
            window.graphite.events.on("file-download-error", this.displayfileDownloadError, this);
            window.graphite.events.on("file-write-error", this.displayFileWriteError, this);
            window.graphite.events.on("creative-cloud-access-error", this.notifyCCAccessError, this);
            window.graphite.events.on("server-taking-too-long", this.notifyServerTakingTooLong, this);
            window.graphite.events.on("fetch-psd-layers-error", this.notifyPSDLayersFetchError, this);
            window.graphite.events.on("route-change", this.hideNotification, this);
            window.graphite.events.on("clear-notification", this.hideNotification, this);
            
            this.render();
            this.$el.find("#close-button").click(
                function () {
                    self.hideNotification();
                }
            );
        },
        
        
        
        fetchNotificationMessage : function (notification) {
            var messageText = "";
            
            if (typeof notification !== undefined && notification !== null) {
                if (notification === "disconnected") {
                    messageText = deps.translate("NOTIFICATION_OFFLINE_CONNECT_TO_CREATIVE_CLOUD");
                } else if (notification === "reconnected") {
                    messageText = deps.translate("YOU_ARE_NOW_CONNECTED");
                }
            }
            
            return messageText;
        },
        
        hideNotification: function () {
            this.$el.removeClass("show").addClass("hide");
            if (this.$notification) {
                this.$notification.text("");
            }
            this.currentDisplayErrorPriority = -1;
        },
        
        notifyUser: function (notification, messageText, autoHide, errorType) {
            if (!errorType) {
                errorType = "WARNING";
            }
            
            var priority = this.errorTypes.indexOf(errorType);
            
            // If current error has more priority, new error can not replace it
            if (priority < this.currentDisplayErrorPriority) {
                return;
            } else {
                this.currentDisplayErrorPriority = priority;
            }
            
            var self = this;
            if (this.$notification) {
                this.$notification.text(messageText);
            }

            this.$el.removeClass("hide").addClass("show");
            this.currentNotification = notification;
            
            if (autoHide === true) {
                setTimeout(function () {
                    self.hideNotification();
                }, 2000);
            }
        },
        
        notifyNetStatusChange: function (notification) {
            var messageText = this.fetchNotificationMessage(notification);
            if (notification === "reconnected") {
                this.notifyUser(notification, messageText, true);
            } else {
                this.notifyUser(notification, messageText, false);
            }
        },
        
        notifyBadFileUploadError: function (notification, failedFiles, totleFiles) {
            var messageText = deps.translate("CAN_ONLY_UPLOAD_PSD_FILES_COUNT_FILES_NOT_UPLOADED", failedFiles, totleFiles);
            this.notifyUser(notification, messageText, false);
        },
        
        notifyValidFileUploadError: function (notification, fileName) {
            var messageText = deps.translate("FAILED_IN_UPLOADING_FILE_FILENAME", fileName);
            this.notifyUser(notification, messageText, false);
        },
        
        notifyDuplicateFileUploadError: function (notification, fileName) {
            var messageText = deps.translate("FAILED_IN_UPLOADING_DUPLICATE_FILE_FILENAME", fileName);
            this.notifyUser(notification, messageText, false);
        },
        
        notifyExtractDataFetchError: function (notification, fileName) {
            var messageText = deps.translate("ERROR_GENERATING_EXTRACT_DATA_FOR_ASSET_NAME", fileName);
            this.notifyUser(notification, messageText, false);
        },
        
        notifyPSDLayersFetchError: function (notification) {
            var messageText = deps.translate("ERROR_FETCHING_PSD_LAYERS");
            this.notifyUser(notification, messageText, false);
        },
        
        displayfileDownloadError: function (errorString, errorType) {
            var messageText = deps.translate(errorString);
            this.notifyUser("DownloadFailed", messageText, false, errorType);
        },

        displayFileWriteError: function (errorString, errorType) {
            var messageText = deps.translate(errorString);
            this.notifyUser("FileWriteFailed", messageText, false, errorType);
        },
        
        notifyCCAccessError: function (notification) {
            var messageText = deps.translate("CREATIVE_CLOUD_ACCESS_ERROR");
            this.notifyUser(notification, messageText, false);
        },
        
        notifyServerTakingTooLong: function (notification) {
            var messageText = deps.translate("SERVER_TAKING_TOO_LONG");
            this.notifyUser(notification, messageText, false);
        },
        
        //------------------------------------------------
        // Render
        //------------------------------------------------

        render: function () {
            var messageText = this.fetchNotificationMessage(this.currentNotification);

            var tmpl = TemplateUtil.createTemplate("#netstatus-notification-bar-template", {"messageText" : messageText});
            $("#launchContainer").append(tmpl);
            this.setElement("#netstatus-notification-bar");
            
            this.$notification = this.$el.find(".netstatus-notification-nowrap");
            return this;
        }

    });
    return DwConnectionAlertToolbarView;
});