/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true*/

define([
    'jquery',
    'underscore',
    'backbone',
    'parfait/ZoomController',
    'ccweb.files.extract/utils/CSSUtil'
], function ($, _, Backbone, ZoomController, CSSUtil) {
    'use strict';

    var DwZoomController = $.extend(ZoomController, {
        zoomRect: function (bounds, invert) {
            var factor = invert ? 1 / this.level : this.level;
            return {
                top: bounds.top * factor,
                left: bounds.left * factor,
                bottom: bounds.bottom * factor,
                right: bounds.right * factor,
                width: (bounds.right - bounds.left) * factor,
                height: (bounds.bottom - bounds.top) * factor
            };
        }
    });
    return DwZoomController;
});