/*    
 Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
    Purpose- This file contains all the Constants that are used in Device Preview Feature
*/
/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*jshint -W100 */

var DWLP_FILEPATHS = {
    LivePreviewPath: "/Shared/DevicePreview"
};

var previewConfig = {
    STAGE: {
        PREVIEW_SERVICE: {
            HOST: "https://cc-api-preview-stage.adobe.io",
            PORT: 443
        }
    },
    
    PRODUCTION: {
        PREVIEW_SERVICE: {
            HOST: "https://cc-api-preview.adobe.io",
            PORT: 443
        }
    },
    
    PREVIEW_ERRORS: {
        //This should match with the Enum in JSObjDevicePreview.h
        ERROR_NONE: 0,
        ERROR_NO_INTERNET: 1,
        ERROR_NO_GUID: 2,
        ERROR_NO_ACCESS_TOKEN: 3,
        ERROR_NO_NODE_SERVER: 4,
        ERROR_NO_SESSION_ID: 5
    },
    
    PAIRING_SERVICE_URLS: {
        API_VERSION: "/api/version",
        API_ENVIRONMENT: "/api/environment",
        API_CREATE_CONSUMER_SESSION: "/api/consumer/%s", // /api/consumer/{desktop-consumer} //i.e. dreamweaver
        API_CREATE_CLIENT: "/api/client/%s",    // /api/client/{desktop-consumer} 
        API_UPDATE_CLIENT: "/api/client/%s/%s",  // /api/client/{desktop-consumer}/{session-id}
        API_PING_SESSION: "/api/ping/%s"        // /api/ping/{session-id}
    },
    
    ICON_PATHS: {
        SPINNER: "images/cc-spinner.gif",
        GENERIC_ERROR: "images/genError.svg",
        NO_INTERNET_ERROR: "images/internetError.svg"
    },
    
    TROUBLESHOOTING_ANCHOR: {
        NO_LAUNCH_ID: '#cannot-launch',
        FIREWALL_ID: '#firewall'
    },
    
    SESSION_PING_INTERVAL: 300000,
    NO_CONTENT_STATUS_CODE: 204,
    BITLY_LOGIN: 'shadowinspect',
    BITLY_API_KEY: 'R_e9e11ed8f2cf4ba0be13bfd9a477fc1d',
    DW_SERVER_HOSTS: '',  //Machine IP address. Will be updated dynamically.
    DW_LOCAL_HOST: '',
    DW_SERVER_PORT: '',  //Machine Port Address. Will be updated dynamically.
    PREVIEW_SHORT_URL: '', //Will be update from preview service
    DW_SERVER_PROTOCOL: 'http',
    DW_COPY_FADE_TIME: 500,
    DW_SERVICE_FAIL_TIMEOUT: 15000,
    INITIAL_SESSION_EXPIRY_TIME: 1800000,
    RECONNECT_ERROR_MARKER: 'reconnect',
    DESCRIPTION_DEFAULT_COLOR: 'rgb(157,157,157)',
    DESCRIPTION_ALERT_COLOR: '#f4ca57',
    THEME: {
		'Darkest': {'G1': '#292929', 'G3' : '#323232', 'G5': '#3d3d3d', 'G8': '#999999', 'G9': '#cccccc', 'G11': '#2a2a2a'},
		'Dark': {'G1': '#414141', 'G3': '#484848', 'G5': '#545454', 'G8': '#b7b7b7', 'G9': '#eeeeee', 'G11': '#3a3a3a'},
        'Lightest': {'G1': '#fafafa', 'G2': '#f5f5f5', 'G3': '#f0f0f0', 'G5': '#dbdbdb', 'G8': '#6f6f6f', 'G9': '#484848', 'G10': '#292929', 'G11': '#e6e6e6'},
        'Light': {'G1': '#dcdcdc', 'G2': '#d0d0d0', 'G3': '#cacaca', 'G5': '#b8b8b8', 'G8': '#555555', 'G9': '#2e2e2e', 'G10': '#0d0d0d', 'G11': '#b5b5b5'}
	}
};

window.preview = {};
window.preview.environment = {};
window.preview.config = previewConfig;