#ifndef _MM_JS_CLASS_API_H_
#define _MM_JS_CLASS_API_H_
typedef struct
{
	int				sizeofClassSpec;		/* required - the size of this struct, used to verify it gets passed correctly from the dll to the app */ 
	const char      *name;					/* required - name for your class, like foo. */
	JSNative		constructor;			/* required - called when someone calls new on your object */
	uint8			nConstructorArgs;		/* required - number of required args for the constructor */
	JSFinalizeOp	finalize;				/* called when your object is destroyed, do any local cleanup from the contructor */
	JSPropertyOp	addProperty;			/* property operations called when a script adds, dels object instance */
    JSPropertyOp	delProperty;
    JSPropertyOp	getProperty;
    JSPropertyOp	setProperty;
	JSPropertySpec	*props;					/* per instance props and funcs. */
	JSFunctionSpec	*funcs;
	JSPropertySpec	*static_props;			/* static props and funcs, the kind that can get called without going var = new foo() first */
	JSFunctionSpec	*static_funcs;
} JS_ClassSpec;

/* default initializer

	JS_ClassSpec() : 
		sizeofClassSpec(sizeof(JS_ClassSpec)),
		name(0),
		constructor(0),
		nConstructorArgs(0),
		finalize(JS_FinalizeStub),
		addProperty(JS_PropertyStub),
		delProperty(JS_PropertyStub),
		getProperty(JS_PropertyStub),
		setProperty(JS_PropertyStub),
		props(0),
		funcs(0),
		static_props(0),
		static_funcs(0)
		{}
*/                                                                            
#endif /* _MM_JS_CLASS_API_H_ */
